#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll a, b;
} Pair;

int cmp(const void* p1, const void* p2) {
    Pair* x = (Pair*)p1;
    Pair* y = (Pair*)p2;
    if (x->a != y->a) return (x->a < y->a) ? -1 : 1;
    return (x->b < y->b) ? -1 : (x->b > y->b);
}

ll countPairs(Pair* arr, int n) {
    qsort(arr, n, sizeof(Pair), cmp);
    ll res = 0;
    int i = 0;
    while (i < n) {
        int j = i+1;
        while (j < n && arr[j].a == arr[i].a && arr[j].b == arr[i].b) j++;
        ll cnt = j - i;
        res += cnt * (cnt - 1) / 2;
        i = j;
    }
    return res;
}

int main() {
    int n;
    scanf("%d", &n);
    ll* x = malloc(n * sizeof(ll));
    ll* y = malloc(n * sizeof(ll));
    for (int i = 0; i < n; i++) scanf("%lld %lld", &x[i], &y[i]);

    Pair* arr = malloc(n*4*sizeof(Pair));
    int idx = 0;

  
    for (int i = 0; i < n; i++) {
        arr[idx].a = y[i];
        arr[idx].b = x[i] & 1; 
        idx++;
    }
    ll res = countPairs(arr, n);

   
    for (int i = 0; i < n; i++) {
        arr[idx].a = x[i];
        arr[idx].b = y[i] & 1;
        idx++;
    }
    res += countPairs(arr+n, n);

  
    for (int i = 0; i < n; i++) {
        arr[idx].a = x[i] + y[i];
        arr[idx].b = (x[i] & 1); 
        idx++;
    }
    res += countPairs(arr+2*n, n);


    for (int i = 0; i < n; i++) {
        arr[idx].a = x[i] - y[i];
        arr[idx].b = (x[i] & 1);
        idx++;
    }
    res += countPairs(arr+3*n, n);

    printf("%lld\n", res);

    free(x);
    free(y);
    free(arr);
    return 0;
}